package com.xebialabs.xlplatform.xlrepository.tck.suites

import com.xebialabs.deployit.repository.ItemConflictException
import com.xebialabs.xlplatform.xlrepository.tck.RepositoryFactory
import com.xebialabs.xlplatform.xlrepository.tck.cis.{Basic, StringProp}
import com.xebialabs.xlplatform.xlrepository.tck.util.{CiHelper, RepositorySuiteBase}

trait RepositoryConflictSuite extends RepositorySuiteBase {
  self: RepositoryFactory[_] =>

  private val gen = generator.genFor("tck-optlock")

  import CiHelper._

  describe("The XL Repository Optimistic Locking Suite") {
    it("should set an optimistic locking token when saving a CI") {
      val ci: Basic = ciHelper.constructCi("repo-tck.Basic", gen.nextId())
      ci.get$token() shouldEqual null
      repository.create(ci)
      val read: Basic = repository.read(ci.getId)
      read.get$token() should not equal null
    }

    it("should update the optimistic locking token when updating a CI") {
      val ci: StringProp = ciHelper.constructCi("repo-tck.StringProp", gen.nextId())
      ci.string = "Foo"
      ci.get$token() shouldEqual null
      repository.create(ci)
      val read = repository.read[StringProp](ci.getId)
      val original = read.get$token()
      read.string = "Bar"
      repository.update(read)
      val updatedToken = repository.read[StringProp](ci.getId).get$token()
      updatedToken should not equal original
    }

    it("should get conflict when saving an outdated ConfigurationItem") {
      val ci: StringProp = ciHelper.constructCi("repo-tck.StringProp", gen.nextId())
      ci.string = "Foo"
      repository.create(ci)
      val read: StringProp = repository.read(ci.getId)
      read.string = "Bar"
      repository.update(read)
      ci.string = "Baz"
      an[ItemConflictException] should be thrownBy {
        repository.update(ci)
      }
    }

    it("should not get conflict when doing 'reality push'") {
      val ci: StringProp = ciHelper.constructCi("repo-tck.StringProp", gen.nextId())
      ci.string = "Foo"
      repository.create(ci)
      val read: StringProp = repository.read(ci.getId)
      read.string = "Bar"
      repository.update(read)
      read.string = "Baz"
      read.set$token(null)
      repository.update(read)
    }
  }

}
