package com.xebialabs.xlplatform.xlrepository.tck.cis

import java.util

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import java.util.{Date, List => JList, Map => JMap, Set => JSet}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Password extends BaseConfigurationItem {
  @Property(password = true) var password: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Hidden extends BaseConfigurationItem {
  @Property(hidden = true, required = false, defaultValue = "Hidden") var hidden: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Transient extends BaseConfigurationItem {
  @Property(isTransient = true, required = false, defaultValue = "Transient") var transient: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class ListOfString extends BaseConfigurationItem {
  @Property() var prop: JList[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class SetOfString extends BaseConfigurationItem {
  @Property() var prop: JSet[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class MapStringString extends BaseConfigurationItem {
  @Property() var prop: JMap[String, String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordListOfString extends BaseConfigurationItem {
  @Property(password = true) var prop: JList[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordSetOfString extends BaseConfigurationItem {
  @Property(password = true) var prop: JSet[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordMapStringString extends BaseConfigurationItem {
  @Property(password = true) var prop: JMap[String, String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class AllProperties extends BaseConfigurationItem {
  @Property(required = false) var stringList: JList[String] = _
  @Property(required = false) var stringSet: JSet[String] = _
  @Property(required = false) var stringStringMap: JMap[String, String] = _
}

class AsContainmentChild extends BaseConfigurationItem
class AsContainmentChild2 extends BaseConfigurationItem

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class AsContainmentChildWithParentReference extends AsContainmentChild {
  @Property(asContainment = true) var parentCi: AsContainmentList = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class AsContainmentList extends BaseConfigurationItem {
  @Property(asContainment = true) private val asContainmentList: JList[AsContainmentChild] = new util.ArrayList[AsContainmentChild]()
  @Property(asContainment = true) private val asContainmentList2: JList[AsContainmentChild2] = new util.ArrayList[AsContainmentChild2]()

  def getAsContainmentList: JList[AsContainmentChild] = {
    asContainmentList
  }
  def getAsContainmentList2: JList[AsContainmentChild2] = {
    asContainmentList2
  }
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class DateCi extends BaseConfigurationItem {
  @Property() var prop: Date = _
}
