package com.xebialabs.xlplatform.xlrepository.tck

import com.xebialabs.license.service.{ LicenseCiCounterFactory, LicenseService, LicenseTransaction}
import com.xebialabs.license.{LicenseCiCounter, InMemoryLicenseCiCounter, License}
import org.joda.time.Period

class NoLicenseService extends LicenseService {

  private val licenseCiCounter: LicenseCiCounter = new InMemoryLicenseCiCounter()

  override def getLicense: License = null

  override def getCounter: LicenseCiCounter = licenseCiCounter

  override def isLicenseExpired: Boolean = false

  override def initialize(ciCounterFactory: LicenseCiCounterFactory): Unit = {}

  override def validate(): Unit = {}

  override def rollbackTransaction(transaction: LicenseTransaction): Unit = {}

  override def startTransaction(): LicenseTransaction = new LicenseTransaction

  override def reload(): Unit = {}

  override def validate(license: License): Unit = {}

  override def getProduct: String = "product"

  override def getValidPeriod: Period = Period.days(1)
}
