package com.xebialabs.xlplatform.xlrepository.tck.util

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.repository.{HistoryService, RepositoryService}
import com.xebialabs.xlplatform.xlrepository.tck.RepositoryFactory
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

trait RepositorySugar extends BeforeAndAfterAll with BeforeAndAfterEach { self: Suite with RepositoryFactory[_] =>
  def repository: RepositoryService
  def history: HistoryService
  def ciHelper: CiHelper

  override protected def beforeAll(): Unit = {
    super.beforeAll()
    LocalBooter.bootWithoutGlobalContext()
    boot()
  }

  override protected def afterAll(): Unit = {
    shutdown()
    super.afterAll()
  }
}
