package com.xebialabs.xlplatform.xlrepository.tck

import java.io.File

import com.xebialabs.deployit.repository.RepositoryMetadataService
import com.xebialabs.license.service.AbstractLicenseService
import com.xebialabs.license.{Clock, License, LicenseReader}

class InMemoryLicenseService(product: String, rms: RepositoryMetadataService, clock: Clock) extends AbstractLicenseService("dummy.lic", product, rms, clock) {
  private[this] val defaultLicense =     """--- License ---
                                           |License version: 4
                                           |Product: XL Deploy
                                           |Licensed to: Roadrunner Inc.
                                           |Contact: Jane Doe
                                           |Edition: Essentials
                                           |--- Signature (SHA1withDSA) ---
                                           |302c02146ca33ac39b330b6fb2c66927efa120b8dc62846602147c493077c6d6d1140b19e6f9e0fc
                                           |569cbd5505c6
                                           |--- End of Signature ---""".stripMargin
  private[this] var testLicense: License = asLicense(defaultLicense)
  license = testLicense
  override protected def readLicense(licenseFile: File): License = testLicense

  def setTestLicense(license: String): Unit = this.testLicense = asLicense(license)
  def setTestLicense(license: License): Unit = this.testLicense = license

  private[this] def asLicense(license: String): License = new LicenseReader().readFromBase64(java.util.Base64.getEncoder.encodeToString(license.getBytes("UTF-8")))
}
