/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.xlrepository.tck.suites;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.ByteArrayFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.test.TmpElem;
import com.xebialabs.xlplatform.test.file;
import com.xebialabs.xlplatform.test.file$;
import com.xebialabs.xlplatform.test.folder;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import com.xebialabs.xlplatform.xlrepository.tck.RepositoryFactory;
import com.xebialabs.xlplatform.xlrepository.tck.cis.SampleContainer;
import com.xebialabs.xlplatform.xlrepository.tck.cis.SampleDerivedFile;
import com.xebialabs.xlplatform.xlrepository.tck.cis.SampleFile;
import com.xebialabs.xlplatform.xlrepository.tck.cis.SampleFolder;
import com.xebialabs.xlplatform.xlrepository.tck.util.IdGenerator;
import com.xebialabs.xlplatform.xlrepository.tck.util.RepositorySuiteBase;
import com.xebialabs.xlplatform.xlrepository.tck.util.RepositorySuiteBase$;
import com.xebialabs.xlplatform.xlrepository.tck.util.RepositorySuiteBase$RichCi$;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Matchers;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=4\u0001\u0002C\u0005\u0011\u0002\u0007\u0005aC\u0017\u0005\u0006G\u0001!\t\u0001\n\u0005\bQ\u0001\u0011\rQ\"\u0001*\u0011\u001d)\u0004A1A\u0005\nYBaA\u000f\u0001!\n\u0013Y\u0004B\u0002$\u0001A\u0013%q\t\u0003\u0004K\u0001\u0001&Ia\u0013\u0005\u0007\u001d\u0002\u0001K\u0011B(\u0003\u001b\u0005\u0013H/\u001b4bGR\u001cV/\u001b;f\u0015\tQ1\"\u0001\u0004tk&$Xm\u001d\u0006\u0003\u00195\t1\u0001^2l\u0015\tqq\"\u0001\u0007yYJ,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0011#\u0005Q\u0001\u0010\u001c9mCR4wN]7\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u00111CU3q_NLGo\u001c:z'VLG/\u001a\"bg\u0016\fa\u0001J5oSR$C#A\u0013\u0011\u0005a1\u0013BA\u0014\u001a\u0005\u0011)f.\u001b;\u0002\u001f\u0005\u0014H/\u001b4bGR|\u0006O]3gSb,\u0012A\u000b\t\u0003WIr!\u0001\f\u0019\u0011\u00055JR\"\u0001\u0018\u000b\u0005=*\u0012A\u0002\u001fs_>$h(\u0003\u000223\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\t\u0014$A\u0002hK:,\u0012a\u000e\t\u0003=aJ!!O\u0010\u0003\u0017%#w)\u001a8fe\u0006$xN]\u0001!g\"|W\u000f\u001c3DC2\u001cW\u000f\\1uK\u0012KgMZ3sK:$8\t[3dWN,X\u000eF\u0002&y\u0011CQ!\u0010\u0003A\u0002y\nQAZ5mKF\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\t\u0002\u0013=4XM\u001d;iKJ,\u0017BA\"A\u00055ye/\u001a:uQ\u0016\u0014XMR5mK\")Q\t\u0002a\u0001}\u0005)a-\u001b7fe\u0005a2\u000f[8vY\u0012\u001c\u0015\r\\2vY\u0006$X-R9vC2\u001c\u0005.Z2lgVlGcA\u0013I\u0013\")Q(\u0002a\u0001}!)Q)\u0002a\u0001}\u0005Yq-\u001a;SKN|WO]2f)\tqD\nC\u0003N\r\u0001\u0007!&\u0001\u0007sKN|WO]2f!\u0006$\b.A\u0002{SB$\"A\u0010)\t\u000bE;\u0001\u0019\u0001*\u0002\u0003\u0019\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0005%|'\"A,\u0002\t)\fg/Y\u0005\u00033R\u0013AAR5mKJ\u00191,X0\u0007\tq\u0003\u0001A\u0017\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003=\u0002i\u0011!\u0003\u0019\u0003A\u001a\u00042!\u00192e\u001b\u0005Y\u0011BA2\f\u0005E\u0011V\r]8tSR|'/\u001f$bGR|'/\u001f\t\u0003K\u001ad\u0001\u0001B\u0005h\u0001\u0005\u0005\t\u0011!B\u0001Q\n\u0019q\fJ\u0019\u0012\u0005%d\u0007C\u0001\rk\u0013\tY\u0017DA\u0004O_RD\u0017N\\4\u0011\u0005ai\u0017B\u00018\u001a\u0005\r\te.\u001f")
public interface ArtifactSuite
extends RepositorySuiteBase {
    public void com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen_$eq(IdGenerator var1);

    public String artifact_prefix();

    public IdGenerator com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen();

    private void shouldCalculateDifferentChecksum(OverthereFile file1, OverthereFile file2) {
        SampleFolder artifact = ((RepositoryFactory)((Object)this)).ciHelper().createArtifact(SampleFolder.class, this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), file1);
        SampleFolder same = ((RepositoryFactory)((Object)this)).ciHelper().createArtifact(SampleFolder.class, this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), file2);
        this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242), Prettifier$.MODULE$.default()).should(this.not().apply(this.equal(null).and(this.not().apply(this.equal("")))), (Object)Equality$.MODULE$.default());
        this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243), Prettifier$.MODULE$.default()).should(this.not().apply(this.equal(same.getChecksum())), (Object)Equality$.MODULE$.default());
    }

    private void shouldCalculateEqualChecksum(OverthereFile file1, OverthereFile file2) {
        SampleFolder artifact = ((RepositoryFactory)((Object)this)).ciHelper().createArtifact(SampleFolder.class, this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), file1);
        SampleFolder same = ((RepositoryFactory)((Object)this)).ciHelper().createArtifact(SampleFolder.class, this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), file2);
        this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249), Prettifier$.MODULE$.default()).should(this.not().apply(this.equal(null).and(this.not().apply(this.equal("")))), (Object)Equality$.MODULE$.default());
        this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250), Prettifier$.MODULE$.default()).shouldEqual((Object)same.getChecksum(), Equality$.MODULE$.default());
    }

    private OverthereFile getResource(String resourcePath) {
        OverthereFile overthereFile;
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
            overthereFile = (OverthereFile)ResourceManagement$.MODULE$.using((Closeable)resource.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OverthereUtils.write((InputStream)is, (OutputStream)baos);
                return new ByteArrayFile(resourcePath, baos.toByteArray());
            });
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Invalid resource path: %s", resourcePath), e);
        }
        return overthereFile;
    }

    private OverthereFile zip(File f2) {
        OverthereFile localFile = LocalFile.valueOf((File)f2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream os = new ZipOutputStream(baos);
        localFile.listFiles().forEach(f -> ArtifactSuite.writeEntry$1(f, "", os));
        return new ByteArrayFile(new StringBuilder(4).append(f2.getPath()).append(".zip").toString(), baos.toByteArray());
    }

    public static /* synthetic */ byte $anonfun$$init$$4(char x$1) {
        return (byte)x$1;
    }

    public static /* synthetic */ byte $anonfun$$init$$11(char x$2) {
        return (byte)x$2;
    }

    public static /* synthetic */ byte $anonfun$$init$$18(char x$3) {
        return (byte)x$3;
    }

    public static /* synthetic */ void $anonfun$zip$1(ZipOutputStream stream$1, InputStream is) {
        OverthereUtils.write((InputStream)is, (OutputStream)stream$1);
    }

    private static void writeEntry$1(OverthereFile f, String path, ZipOutputStream stream) {
        block1: {
            block0: {
                if (!f.isFile()) break block0;
                stream.putNextEntry(new ZipEntry(new StringBuilder(0).append(path).append(f.getName()).toString()));
                ResourceManagement$.MODULE$.using((Closeable)f.getInputStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ArtifactSuite.$anonfun$zip$1(stream, is);
                    return BoxedUnit.UNIT;
                });
                stream.closeEntry();
                break block1;
            }
            if (!f.isDirectory()) break block1;
            stream.putNextEntry(new ZipEntry(new StringBuilder(1).append(path).append(f.getName()).append("/").toString()));
            stream.closeEntry();
            f.listFiles().forEach(subFile -> ArtifactSuite.writeEntry$1(subFile, new StringBuilder(1).append(path).append(f.getName()).append("/").toString(), stream));
        }
    }

    public static void $init$(ArtifactSuite $this) {
        $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen_$eq($this.generator().genFor("tck-artifact"));
        $this.describe("The Artifact suite", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.it().apply("should read / write a File artifact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                byte[] artifactData = "**********".getBytes();
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("file-1.0.ext", artifactData));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                WorkDir workDir = $this.workDirFactory().newWorkDir();
                SampleFile read = (SampleFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), workDir);
                OverthereFile file = read.getFile();
                $this.convertToAnyShouldWrapper(file, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40), Prettifier$.MODULE$.default()).shouldNot($this.be().apply(null));
                $this.convertToStringShouldWrapper(file.getPath(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Prettifier$.MODULE$.default()).should($this.startWith().apply(workDir.getPath()));
                $this.convertToStringShouldWrapper(file.getName(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42), Prettifier$.MODULE$.default()).shouldEqual((Object)"file-1.0.ext", Equality$.MODULE$.default());
                return (Assertion)ResourceManagement$.MODULE$.using((Closeable)file.getInputStream(), (Function1 & Serializable & scala.Serializable)is -> $this.convertToAnyShouldWrapper(Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ArtifactSuite.$anonfun$$init$$4(BoxesRunTime.unboxToChar((Object)x$1)))).toArray(ClassTag$.MODULE$.Byte()), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44), Prettifier$.MODULE$.default()).shouldEqual((Object)artifactData, Equality$.MODULE$.default()));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            $this.ignore("should create new file if artifact is read second time in different context", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                byte[] artifactData = "**********".getBytes();
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("file-2.0.ext", artifactData));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                WorkDir workDir = $this.workDirFactory().newWorkDir();
                SampleFile read = (SampleFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), workDir);
                WorkDir workDir2 = $this.workDirFactory().newWorkDir();
                SampleFile read2 = (SampleFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), workDir2);
                $this.convertToStringShouldWrapper(workDir.getPath(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).shouldNot($this.equal(workDir2.getPath()), (Object)Equality$.MODULE$.default());
                $this.convertToAnyShouldWrapper(read.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60), Prettifier$.MODULE$.default()).shouldNot($this.be().apply((Object)$this.theSameInstanceAs().apply((Object)read2.getFile())));
                $this.convertToStringShouldWrapper(read.getFile().getPath(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61), Prettifier$.MODULE$.default()).shouldNot($this.equal(read2.getFile().getPath()), (Object)Equality$.MODULE$.default());
                return $this.convertToStringShouldWrapper(read.getFile().getName(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62), Prettifier$.MODULE$.default()).shouldEqual((Object)read2.getFile().getName(), Equality$.MODULE$.default());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            $this.it().apply("should read / write a Folder artifact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                File artifactFolder = $this.mk((TmpElem)new folder("config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("config1.properties", "key=value\nanotherkey=anothervalue\n")})));
                SampleFolder artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFolder.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), LocalFile.valueOf((File)artifactFolder));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFolder[]{artifact});
                WorkDir workDir = $this.workDirFactory().newWorkDir();
                SampleFolder read = (SampleFolder)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), workDir);
                $this.convertToAnyShouldWrapper(read.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).shouldBe(Symbol$.MODULE$.apply("directory"), Predef$.MODULE$.$conforms());
                return $this.convertToStringShouldWrapper(read.getFile().getName(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72), Prettifier$.MODULE$.default()).shouldEqual((Object)"config", Equality$.MODULE$.default());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            $this.it().apply("should deal with derived artifacts which do not have a source artifact counterpart set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleContainer container = ((RepositoryFactory)((Object)$this)).ciHelper().constructConfigurationItem(SampleContainer.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId());
                SampleDerivedFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleDerivedFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().subId((ConfigurationItem)container), null);
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{artifact, container});
                SampleDerivedFile read = (SampleDerivedFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), $this.workDirFactory().newWorkDir());
                Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = $this.convertToAnyShouldWrapper(read.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default());
                return TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), $this.a(ClassTag$.MODULE$.apply(DerivedArtifactFile.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            $this.it().apply("should not read the file for a derived artifact when there is no workdir set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleFile source = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("test.txt", "**********".getBytes()));
                SampleContainer container = ((RepositoryFactory)((Object)$this)).ciHelper().constructConfigurationItem(SampleContainer.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId());
                SampleDerivedFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleDerivedFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().subId((ConfigurationItem)container), null);
                artifact.setDeployable((Deployable)source);
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{source, container, artifact});
                SampleDerivedFile read = (SampleDerivedFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId());
                Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = $this.convertToAnyShouldWrapper(read.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90), Prettifier$.MODULE$.default());
                return TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), $this.a(ClassTag$.MODULE$.apply(DerivedArtifactFile.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            $this.it().apply("should create a derived artifact that replaces the contents with the provided placeholders", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleFile source = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("foobarbaz.txt", "{{foo}}bar{{baz}}\n".getBytes()));
                SampleContainer container = ((RepositoryFactory)((Object)$this)).ciHelper().constructConfigurationItem(SampleContainer.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId());
                SampleDerivedFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleDerivedFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().subId((ConfigurationItem)container), null);
                artifact.setDeployable((Deployable)source);
                artifact.setPlaceholders((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"r1 "), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)" r2")}))).asJava());
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{source, container, artifact});
                SampleDerivedFile read = (SampleDerivedFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), $this.workDirFactory().newWorkDir());
                return (Assertion)ResourceManagement$.MODULE$.using((Closeable)read.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)is -> $this.convertToAnyShouldWrapper(Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ArtifactSuite.$anonfun$$init$$11(BoxesRunTime.unboxToChar((Object)x$2)))).toArray(ClassTag$.MODULE$.Byte()), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).shouldEqual((Object)"r1 bar r2\n".getBytes(), Equality$.MODULE$.default()));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            $this.it().apply("should calculate the checksum on create if it is not set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("checksum.txt", "**********".getBytes()));
                $this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108), Prettifier$.MODULE$.default()).shouldEqual(null, Predef$.MODULE$.$conforms());
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                return $this.convertToStringShouldWrapper(artifact.getChecksum(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110), Prettifier$.MODULE$.default()).should($this.not().apply($this.equal(null)).and($this.not().apply($this.equal(""))), (Object)Equality$.MODULE$.default());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            $this.it().apply("should not create artifact without data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), null);
                return $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).shouldBe($this.thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact})), Prettifier$.MODULE$.default(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            $this.it().apply("should create artifact which references an external artifact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("original.txt", "**********".getBytes()));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                SampleFile externalArtifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), null);
                externalArtifact.setProperty("fileUri", new StringBuilder(14).append($this.artifact_prefix()).append(":").append(artifact.getId()).append("/original.txt").toString());
                externalArtifact.setFile(artifact.getFile());
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{externalArtifact});
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            $this.it().apply("should let create an artifact by copying an existing one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                byte[] content = "**********".getBytes();
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("original.txt", content));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                SampleFile artifactToCopy = (SampleFile)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), $this.workDirFactory().newWorkDir());
                artifactToCopy.getFile().getPath();
                artifactToCopy.setId($this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId());
                artifactToCopy.set$token(null);
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifactToCopy});
                SampleFile copiedArtifact = (SampleFile)((RepositoryFactory)((Object)$this)).repository().read(artifactToCopy.getId(), $this.workDirFactory().newWorkDir());
                return (Assertion)ResourceManagement$.MODULE$.using((Closeable)copiedArtifact.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)is -> $this.convertToAnyShouldWrapper(Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)ArtifactSuite.$anonfun$$init$$18(BoxesRunTime.unboxToChar((Object)x$3)))).toArray(ClassTag$.MODULE$.Byte()), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).shouldEqual((Object)content, Equality$.MODULE$.default()));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            $this.it().apply("should update an artifact without passing new data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SampleFile artifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), (OverthereFile)new ByteArrayFile("original.txt", "**********".getBytes()));
                ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new SampleFile[]{artifact});
                SampleFile newArtifact = ((RepositoryFactory)((Object)$this)).ciHelper().constructArtifact(SampleFile.class, artifact.getId(), null);
                newArtifact.string_$eq("new value");
                $this.convertToAnyShouldWrapper(newArtifact.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152), Prettifier$.MODULE$.default()).shouldEqual(null, Predef$.MODULE$.$conforms());
                ((RepositoryFactory)((Object)$this)).repository().update((ConfigurationItem[])new SampleFile[]{newArtifact});
                $this.convertToAnyShouldWrapper(RepositorySuiteBase$RichCi$.MODULE$.property$extension(RepositorySuiteBase$.MODULE$.RichCi((ConfigurationItem)artifact), "string"), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).shouldBe($this.storedInRepository().equal("new value"));
                return $this.convertToAnyShouldWrapper(RepositorySuiteBase$RichCi$.MODULE$.property$extension(RepositorySuiteBase$.MODULE$.RichCi((ConfigurationItem)artifact), "fileUri"), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).shouldBe($this.storedInRepository().equal(artifact.getFileUri()));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            $this.it().apply("should calculate same checksum for folder as zip that only differs in zip name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))}))));
                $this.shouldCalculateEqualChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            $this.it().apply("should calculate checksum correctly on for different zipped folder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("differ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test. With a modification.")}))}))));
                $this.shouldCalculateDifferentChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            $this.it().apply("should calculate same checksum for complex folder as zip that only differs in zip name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("same-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                $this.shouldCalculateEqualChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            $this.it().apply("should calculate different checksum for complex folder as zip that has moved a file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                $this.shouldCalculateDifferentChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            $this.it().apply("should calculate different checksum for complex folder as zip that has a new empty file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0])), new file("empty-file", file$.MODULE$.apply$default$2())}))));
                $this.shouldCalculateDifferentChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            $this.it().apply("should calculate different checksum for complex folder as zip that has a missing empty dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OverthereFile file1 = $this.zip($this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))}))));
                OverthereFile file2 = $this.zip($this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))}))));
                $this.shouldCalculateDifferentChecksum(file1, file2);
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            $this.it().apply("should calculate same checksum for folder that only differs in folder name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))})));
                File file2 = $this.mk((TmpElem)new folder("same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))})));
                $this.shouldCalculateEqualChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            $this.it().apply("should calculate checksum correctly for different folder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))})));
                File file2 = $this.mk((TmpElem)new folder("differ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test. With a modification.")}))})));
                $this.shouldCalculateDifferentChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            $this.it().apply("should calculate same checksum for complex folder that only differs in folder name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                File file2 = $this.mk((TmpElem)new folder("same-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                $this.shouldCalculateEqualChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            $this.it().apply("should calculate different checksum for complex folder that has moved a file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                File file2 = $this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                $this.shouldCalculateDifferentChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            $this.it().apply("should calculate different checksum for complex folder that has a new empty file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                File file2 = $this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0])), new file("empty-file", file$.MODULE$.apply$default$2())})));
                $this.shouldCalculateDifferentChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            $this.it().apply("should calculate different checksum for complex folder that has a missing empty dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                File file1 = $this.mk((TmpElem)new folder("initial-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")})), new folder("empty-dir", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0]))})));
                File file2 = $this.mk((TmpElem)new folder("differ-complex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new folder("texts2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[]{new file("test.txt", "This is a test.")}))})));
                $this.shouldCalculateDifferentChecksum(LocalFile.valueOf((File)file1), LocalFile.valueOf((File)file2));
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            $this.it().apply("should store empty folder artifact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                File file2 = $this.mk((TmpElem)new folder("empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TmpElem[0])));
                SampleFolder artifact = ((RepositoryFactory)((Object)$this)).ciHelper().createArtifact(SampleFolder.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$ArtifactSuite$$gen().nextId(), LocalFile.valueOf((File)file2));
                SampleFolder read = (SampleFolder)((RepositoryFactory)((Object)$this)).repository().read(artifact.getId(), $this.workDirFactory().newWorkDir());
                $this.convertToAnyShouldWrapper(read.getFile(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234), Prettifier$.MODULE$.default()).shouldNot($this.equal(null));
                return $this.convertToAnyShouldWrapper(read.getFile().listFiles(), new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235), Prettifier$.MODULE$.default()).shouldBe($this.empty(), Emptiness$.MODULE$.emptinessOfJavaCollection());
            }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("ArtifactSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }
}

