package com.xebialabs.xlplatform.xlrepository.tck

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.{HistoryService, RepositoryMetadataService, RepositoryService}
import com.xebialabs.xlplatform.xlrepository.tck.util.CiHelper

trait RepositoryFactory[A] {
  var repository: RepositoryService = _
  var metadataService: RepositoryMetadataService = _
  var history: HistoryService = _
  var licenseService: InMemoryLicenseService = _

  def ciHelper: CiHelper = new CiHelper(repository)

  def boot(): Unit
  def shutdown(): Unit

  def getRepositoryService: RepositoryService
  def getRepositoryMetadataService: RepositoryMetadataService
  def getHistoryService: HistoryService

  def getStoredValue[T <: AnyRef](ci: ConfigurationItem, property: String): T
  def setStoredValue[T <: AnyRef](ci: ConfigurationItem, property: String, value: T): Unit
  def hasProperty(id: String, propertyName: String): Boolean
  def removeProperty(id: String, propertyName: String): Unit
  def getNumberOfVersions(id: String, ctx: RepoContext = EmptyContext): (Long, NonEmptyContext)
  def getRepositoryId: String

  def withLicense(license: String)(body: => Unit): Unit = {
    val currentLicense = licenseService.getLicense
    licenseService.setTestLicense(license)
    licenseService.reload()
    try {
      body
    } finally {
      licenseService.setTestLicense(currentLicense)
      licenseService.reload()
    }
  }

  sealed trait RepoContext
  case class NonEmptyContext(metaData: A) extends RepoContext
  case object EmptyContext extends RepoContext
}
