package com.xebialabs.xlplatform.xlrepository.tck.cis

import java.util.{Set => JSet}

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.deployit.plugin.api.udm.base.{BaseConfigurationItem, BaseDeployable}

class Resource extends BaseDeployable
class SampleSubclass extends SampleCi

class GrandChild extends BaseConfigurationItem {
  @Property(asContainment = true) private var parent: Child = null
}

@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE) class Referencing extends BaseConfigurationItem {
  @Property(required = false) private var ciProperty: Referencing = null
  @Property(required = false) private var cisProperty: JSet[Referencing] = null

  def setCiProperty(ciProperty: Referencing) {
    this.ciProperty = ciProperty
  }

  def setCisProperty(cisProperty: JSet[Referencing]) {
    this.cisProperty = cisProperty
  }
}