package com.xebialabs.xlplatform.xlrepository.tck.cis

import com.xebialabs.deployit.plugin.api.udm.{Property, Metadata}
import com.xebialabs.deployit.plugin.api.udm.base.{BaseDeployed, BaseContainer, BaseDeployable, BaseConfigurationItem}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class Versioned extends BaseConfigurationItem {
  @Property(required = false) var stringProperty: String = null

  def setStringProperty(stringProp: String) {
    this.stringProperty = stringProp
  }

  def getStringProperty: String = {
    stringProperty
  }
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false) class Unversioned extends BaseConfigurationItem {
  @Property(required = false) var stringProperty: String = null

  def setStringProperty(stringProperty: String) {
    this.stringProperty = stringProperty
  }
}

class SampleDeployedProperty extends BaseDeployed[BaseDeployable, BaseContainer] {
  @Property(required = false) private var stringProperty: String = null
}
