package com.xebialabs.xlplatform.scheduler.step;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.xlplatform.scheduler.spring.ServiceHolder;

@SuppressWarnings({"serial"})
public class DefaultGarbageCollectionStep implements Step {

    private static final Logger logger = LoggerFactory.getLogger(DefaultGarbageCollectionStep.class);

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Running garbage collection on the repository";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        logger.info("Running garbage collector to compact the DataStore");

        ServiceHolder.getGarabageCollectionService().runGarbageCollector();

        // Task is non-interactive, so always returning success.
        return StepExitCode.SUCCESS;
    }
}
