package com.xebialabs.xlplatform.scheduler

import akka.actor.ActorSystem
import com.typesafe.config.ConfigFactory
import grizzled.slf4j.Logging
import scala.concurrent.duration._

import scala.concurrent.Await._
import scala.concurrent.ExecutionContext


object SchedulerActorSystem extends Logging {

  val actorSystem: ActorSystem = newActorSystem

  private[scheduler] def newActorSystem: ActorSystem = {
    logger.info("Starting the xl-scheduler actor system")
    ActorSystem.create("xl-scheduler-system", ConfigFactory.load("scheduler.conf").withFallback(ConfigFactory.load("reference.conf")))
  }

  lazy val scheduler = actorSystem.actorOf(Scheduler.props(), "scheduler")
  lazy val controlTaskExecutor = actorSystem.actorOf(ControlTaskExecutor.props(), "control-task-executor")

  def shutdownTheSystem() = {
    logger.info("Shutting down the xl-scheduler actor system...")
    result(actorSystem.terminate(), 20.seconds)
  }

  implicit lazy val dispatcher: ExecutionContext = actorSystem.dispatcher
}