package com.xebialabs.xlplatform.scheduler.ci

import java.util.{ArrayList => JArrayList, List => JList, Map => JMap, HashMap => JHashMap}

import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.{ControlTask, Metadata, Property}

import scala.beans.BeanProperty


@Metadata(virtual = true, root = CONFIGURATION, description = "Base scheduled administrative job which delegates execution to a list of steps")
class StepJob extends CronJob with ControlTaskInvokable {
  @BeanProperty
  @Property(label = "Parameters", required = false, hidden = true, description = "Optional map of parameters to pass to the steps")
  var controlTaskParams: JMap[String, String] = new JHashMap[String, String]()

  override def getConfigurationItemId(): String = getId

  override def getControlTaskName(): String = "executeJob"

  @ControlTask(label = "Execute job now") def executeJob(params: JMap[String, String]): JList[Step] = {
    getSteps(params)
  }

  def getSteps(params: JMap[String, String]): JList[Step] = new JArrayList[Step]()
}
