package com.xebialabs.xlplatform.scheduler.step;

import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.xlplatform.scheduler.spring.ServiceHolder;

@SuppressWarnings({"serial"})
public class DefaultGarbageCollectionStep implements Step {

    private static final Logger logger = LoggerFactory.getLogger(DefaultGarbageCollectionStep.class);

    private final GarbageCollectionService garbageCollectionService;

    public DefaultGarbageCollectionStep() {
        this(ServiceHolder.getGarabageCollectionService());
    }

    public DefaultGarbageCollectionStep(GarbageCollectionService garbageCollectionService) {
        this.garbageCollectionService = garbageCollectionService;
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public String getDescription() {
        return "Running garbage collection on the repository";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        logger.info("Running garbage collector to compact the DataStore");

        garbageCollectionService.runGarbageCollector();

        // Task is non-interactive, so always returning success.
        return StepExitCode.SUCCESS;
    }
}
