package com.xebialabs.xlplatform.scheduler;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;

import org.springframework.scheduling.support.CronSequenceGenerator;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = CronPattern.Validator.class, type = "cronPattern")
@ApplicableTo(PropertyKind.STRING)
@Target(ElementType.FIELD)
public @interface CronPattern {
    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        @Override
        public void validate(String value, ValidationContext context) {
            try {
                new CronSequenceGenerator(value).next(new Date());
            } catch (IllegalArgumentException e) {
                context.error(e.getMessage());
            }
        }

    }
}
