package com.xebialabs.platform.script.jython

object Syntactic {

  val wrapperLib = ScriptSource.byResource("syntactical/sugar.py")

  val loggerLib = ScriptSource.byResource("xl_builtins/logger.py")

  def wrapperCode(contextBindingNames: Iterable[String]): ScriptSource = {
    val crlf = System.lineSeparator()
    val content = contextBindingNames.map { key => s"$key = _wrapper.wrap($key)" }.mkString(crlf)
    ScriptSource.byContent(content)
  }

  def wrapperCodeWithLib(contextBindingNames: Iterable[String]): Seq[ScriptSource] = {
    Seq(wrapperLib, wrapperCode(contextBindingNames))
  }

}
