package com.xebialabs.xlplatform.script.jython

import java.util.{List => JList}

import com.xebialabs.platform.script.jython.{JythonSugarProvider, ScriptSource}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

object JythonSugarDiscovery {
  var providers: List[JythonSugarProvider] = Nil

  def getExtensionResources: List[ScriptSource] = providers.map(_.source)
}

@Service
class JythonSugarDiscovery(@Autowired(required = false) providers: JList[JythonSugarProvider]) {
  JythonSugarDiscovery.providers = Option(providers).map(_.asScala.toList).getOrElse(Nil)
}
