package com.xebialabs.deployit.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@SuppressWarnings("serial")
public class MapStringStringView implements Map<String, String>, Serializable {
    public static final Function<String,StringValue> STRING_STRING_VALUE_FUNCTION = input -> (StringValue) stringToStringValue(input);
    private Map<String, StringValue> wrapped = new HashMap<>();

    public MapStringStringView() {
    }

    public MapStringStringView(Map<String, StringValue> wrapped) {
        if (wrapped instanceof Serializable) {
            this.wrapped = wrapped;
        } else {
            this.wrapped = new HashMap<>(wrapped);
        }
    }

    @Override
    public int size() {
        return wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return wrapped.containsValue(stringToStringValue(value));
    }

    @Override
    public String get(Object key) {
        StringValue wrappedValue = getWrappedValue(key);
        return wrappedValue != null ? wrappedValue.toString() : null;
    }

    public StringValue getWrappedValue(Object key) {
        return wrapped.get(key);
    }

    @Override
    public String put(String key, String value) {
        StringValue put = wrapped.put(key, (StringValue) stringToStringValue(value));
        return put != null ? put.toString() : null;
    }

    public StringValue put(String key, StringValue value) {
        return wrapped.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return wrapped.remove(key).toString();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m instanceof MapStringStringView) {
            wrapped.putAll(((MapStringStringView) m).getWrapped());
        } else {
            Set<? extends Entry<? extends String, ? extends String>> entries = m.entrySet();
            // Force cast to get rid of some nasty shizzle
            @SuppressWarnings("unchecked")
            Stream<Entry<String, String>> stream = (Stream<Entry<String, String>>) entries.stream();
            Collector<Entry<String, String>, ?, Map<String, StringValue>> tMapCollector = Collectors.toMap(Entry::getKey, e -> STRING_STRING_VALUE_FUNCTION.apply(e.getValue()));
            wrapped.putAll(stream.collect(tMapCollector));
        }
    }

    @Override
    public void clear() {
        wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return wrapped.keySet();
    }

    @Override
    public Collection<String> values() {
        return wrapped.values().stream().map(StringValue::toString).collect(Collectors.toList());
    }

    @Override
    public Set<Entry<String, String>> entrySet() {
        return wrapped.entrySet().stream().map(e -> new HashMap.SimpleEntry<>(e.getKey(), e.getValue().toString())).collect(Collectors.toSet());
    }

    public Map<String, StringValue> getWrapped() {
        return wrapped;
    }

    @Override
    public int hashCode() {
        return wrapped.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) return false;
        else if (obj instanceof MapStringStringView) {
            return wrapped.equals(((MapStringStringView) obj).getWrapped());
        } else if (obj instanceof Map) {
            return wrapped.equals(obj);
        }
        return false;
    }

    @Override
    public String toString() {
        return "MapStringStringView[" + wrapped.toString() + "]";
    }

    protected static Object stringToStringValue(Object o) {
        if (o instanceof String) {
            return new StringValue((String) o);
        }
        return o;
    }

    public static MapStringStringView from(Map<String, String> mapStringString) {
        if (mapStringString instanceof MapStringStringView) {
            return (MapStringStringView) mapStringString;
        } else {
            MapStringStringView stringView = new MapStringStringView();
            if (mapStringString != null) {
                stringView.putAll(mapStringString);
            }
            return stringView;
        }
    }

    public static MapStringStringView copy(Map<String, String> map) {
        if (map instanceof MapStringStringView) {
            return new MapStringStringView(new HashMap<>(((MapStringStringView) map).getWrapped()));
        } else {
            return from(map);
        }
    }

    /**
     * Return an encrypted view of all the values of the map.
     * @return an encrypted view
     */
    public MapStringStringView encrypt() {
        HashMap<String, StringValue> newMap = new HashMap<>();
        for (String s : wrapped.keySet()) {
            newMap.put(s, wrapped.get(s).encrypt());
        }
        return new MapStringStringView(newMap);
    }
}
