package com.xebialabs.deployit.security.crowd

import java.io.{ByteArrayInputStream, InputStreamReader}

import com.fasterxml.jackson.databind.ObjectMapper
import org.springframework.core.convert.converter.Converter
import org.springframework.core.serializer.support.DeserializingConverter
import org.springframework.security.core.context.SecurityContext

class CrowdDeserializingConverter(mapper: ObjectMapper, classLoader: ClassLoader) extends Converter[Array[Byte], AnyRef] {
  private val defaultDeserializingConverter = new DeserializingConverter(classLoader)

  override def convert(byteArray: Array[Byte]): AnyRef =
    try {
      val in = new ByteArrayInputStream(byteArray)
      val reader = new InputStreamReader(in)
      mapper.readValue(reader, classOf[SecurityContext])
    } catch {
      case _: Throwable =>
        defaultDeserializingConverter.convert(byteArray)
    }
}
