package com.xebialabs.deployit.security.authentication;

import org.springframework.security.core.AuthenticationException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class BasicAuthenticationEntryPoint extends org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint {

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException)
            throws IOException {
        if ("true".equals(request.getHeader("X-HTTP-Auth-Override"))) {
            HttpServletResponse httpResponse = (HttpServletResponse) response;
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + getRealmName() + "\"");
            httpResponse.sendError(HttpServletResponse.SC_FORBIDDEN, authException.getMessage());
        } else {
            super.commence(request, response, authException);
        }
    }
}
