package com.xebialabs.deployit.security.crowd

import java.io.{ByteArrayOutputStream, OutputStreamWriter}

import com.fasterxml.jackson.databind.ObjectMapper
import org.springframework.core.convert.converter.Converter
import org.springframework.core.serializer.support.SerializingConverter
import org.springframework.security.core.context.SecurityContext

class CrowdSerializingConverter(mapper: ObjectMapper) extends Converter[AnyRef, Array[Byte]] {
  private val defaultSerializingConverter = new SerializingConverter

  private def serializeSecurityContext(securityContext: SecurityContext) = {
    val out = new ByteArrayOutputStream()
    val writer = new OutputStreamWriter(out)
    mapper.writeValue(writer, securityContext.asInstanceOf[SecurityContext])
    out.toByteArray
  }

  override def convert(someObject: AnyRef): Array[Byte] =
    someObject match {
      case securityContext: SecurityContext => serializeSecurityContext(securityContext)
      case _@other => defaultSerializingConverter.convert(other)
    }
}
