package com.xebialabs.deployit.security;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.permission.Permission;

public interface PermissionEditor {

    Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order);

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem) {
        return this.readPermissions(onConfigurationItem, null, null, null);
    }

    void editPermissions(String onConfigurationItem, Map<Role, Set<Permission>> permissions);
}
