package com.xebialabs.deployit.security.authentication.viewas;

import com.xebialabs.deployit.security.Role;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.List;

@Component("viewAsData")
@Scope(value="session", proxyMode = ScopedProxyMode.TARGET_CLASS)
public class ViewAsData implements Serializable {

    private List<Role> roles;
    private Authentication user;

    public ViewAsData() {}

    public ViewAsData(Authentication user) {
        this.user = user;
    }

    public ViewAsData(List<Role> roles) {
        this.roles = roles;
    }

    public List<Role> getRoles() {
        return roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public Authentication getUser() {
        return user;
    }

    public void setUser(Authentication user) {
        this.user = user;
    }

}
