package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.permission.Permission;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface PermissionEditor {

    Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order, Boolean includeInherited);

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order) {
        return this.readPermissions(onConfigurationItem, rolePattern, paging, order, false);
    }

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, Boolean includeInherited) {
        return this.readPermissions(onConfigurationItem, null, null, null, includeInherited);
    }

    default Map<Role, Set<Permission>> readPermissions(String onConfigurationItem) {
        return this.readPermissions(onConfigurationItem,  false);
    }

    default void grant(Role role, Permission permission, String id) {
        Map<Role, Set<Permission>> rolePermissions = readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet<>()).add(permission);
        editPermissions(id, rolePermissions);
    }

    default void revoke(Role role, Permission permission, String id) {
        Map<Role, Set<Permission>> rolePermissions = readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet<>()).remove(permission);
        editPermissions(id, rolePermissions);
    }

    void editPermissions(String onConfigurationItem, Map<Role, Set<Permission>> permissions);

    void updatePermissions(String onConfigurationItem, Map<Role, List<Permission>> addedPermissions, Map<Role, List<Permission>> removedPermissions);
}

