package com.xebialabs.deployit.security.permission;

import static com.xebialabs.deployit.security.permission.Permission.definePermission;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.CI;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.GLOBAL;

public class PlatformPermissions {

    public static final Permission ADMIN = definePermission("admin", GLOBAL);
    public static final Permission LOGIN = definePermission("login", GLOBAL);
    public static final Permission EDIT_SECURITY = definePermission("security#edit", GLOBAL);
    public static final Permission VIEW_SECURITY = definePermission("security#view", GLOBAL);
    public static final Permission READ = definePermission("read", CI, new ReadPermissionHandler(), true);
    public static final Permission EDIT_REPO = definePermission("repo#edit", CI);
    public static final Permission REPORT_VIEW = definePermission("report#view", GLOBAL);

    public static void init() {
        // Dummy method that can be called to ensure that the class is loaded and the permissions are registered
    }
}
