package com.xebialabs.deployit.security;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SHA256PasswordEncoder implements PasswordEncoder {

    @Override
    public String encode(final CharSequence rawPassword) {
        try {
            return PasswordUtils.buildPasswordHash(rawPassword.toString());
        } catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such hashing algorithm", e);
        } catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Wrong enconding", e);
        }
    }

    @Override
    public boolean matches(final CharSequence rawPassword, final String encodedPassword) {
        return PasswordUtils.isSame(encodedPassword, rawPassword.toString());
    }
}
