package com.xebialabs.deployit.security.authentication;

import java.util.LinkedList;
import java.util.List;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;

/**
 * Added support to use PagedResultsDirContextProcessor as default if no DirContextProcessor is passed with search operation
 *
 * Issue was reported with spring-security (https://github.com/spring-projects/spring-security/issues/14741).
 * Once fixed, remove this class.
 */
public class CustomLdapTemplate extends SpringSecurityLdapTemplate {

    private final int pageSize;

    public CustomLdapTemplate(final ContextSource contextSource, final int pageSize) {
        super(contextSource);
        this.pageSize = pageSize;
    }

    @Override
    public <T> List<T> search(String base, String filter, SearchControls controls, ContextMapper<T> mapper) {
        PagedResultsDirContextProcessor dirContextProcessor = new PagedResultsDirContextProcessor(pageSize);
        List<T> result = new LinkedList<>();
        do {
            List<T> oneResult = this.search(base, filter, controls, mapper, dirContextProcessor);
            result.addAll(oneResult);
        } while (dirContextProcessor.hasMore());
        return result;
    }

    @Override
    public <T> List<T> search(Name base, String filter, SearchControls controls, ContextMapper<T> mapper) {
        PagedResultsDirContextProcessor dirContextProcessor = new PagedResultsDirContextProcessor(pageSize);
        List<T> result = new LinkedList<>();
        do {
            List<T> oneResult = this.search(base, filter, controls, mapper, dirContextProcessor);
            result.addAll(oneResult);
        } while (dirContextProcessor.hasMore());
        return result;
    }

    @Override
    public <T> List<T> search(Name base, String filter, SearchControls controls, AttributesMapper<T> mapper) {
        PagedResultsDirContextProcessor dirContextProcessor = new PagedResultsDirContextProcessor(pageSize);
        List<T> result = new LinkedList<>();
        do {
            List<T> oneResult = this.search(base, filter, controls, mapper, dirContextProcessor);
            result.addAll(oneResult);
        } while (dirContextProcessor.hasMore());
        return result;
    }

    @Override
    public <T> List<T> search(String base, String filter, SearchControls controls, AttributesMapper<T> mapper) {
        PagedResultsDirContextProcessor dirContextProcessor = new PagedResultsDirContextProcessor(pageSize);
        List<T> result = new LinkedList<>();
        do {
            List<T> oneResult = this.search(base, filter, controls, mapper, dirContextProcessor);
            result.addAll(oneResult);
        } while (dirContextProcessor.hasMore());
        return result;
    }

}
