package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RolesPermissionsPair;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.xebialabs.deployit.booter.local.utils.Strings.*;

public class PermissionHandler {

    private Permission permission;

    public PermissionHandler(Permission permission) {
        this.permission = permission;
    }

    public enum Level {
        GLOBAL,
        CI,
        BOTH
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(String onConfigurationItem) {
        if (isBlank(onConfigurationItem)) {
            return PermissionHelper.hasPermission(getPermission());
        }
        return PermissionHelper.hasPermission(getPermission()) || PermissionHelper.hasPermission(getPermission(), onConfigurationItem);
    }

    public Map<String, Boolean> hasPermission(List<String> onConfigurationItems) {
        return PermissionHelper.hasPermission(getPermission(), onConfigurationItems);
    }

    public void applyPermission(SearchParameters parameters) {
        PermissionHelper.applyPermission(parameters, getPermission());
    }

    public RolesPermissionsPair getRolesPermissionsPair() {
        return new RolesPermissionsPair(
                PermissionHelper.getCurrentRoles().stream().map(Role::getId).collect(Collectors.toList()),
                Collections.singletonList(getPermission().getPermissionName()));
    }

    public boolean isCurrentUserAdmin() {
        return PermissionHelper.isCurrentUserAdmin();
    }
}
