package com.xebialabs.xlplatform.support.report.render

import com.samskivert.mustache.Mustache
import grizzled.slf4j.Logging

import java.io.{BufferedReader, InputStreamReader, Reader}
import java.lang.Thread.currentThread

object Templater extends Logging {

  def processTemplate(templateName: String, context: java.util.Map[String, Any]): String = {
    mustacheCompiler
      .compile(getTemplateReader(templateName))
      .execute(context)
  }

  private def mustacheCompiler: Mustache.Compiler = {
    Mustache.compiler().defaultValue("")
  }

  private def getTemplateReader(templateName: String): Reader = {
    val inputStream = currentThread().getContextClassLoader.getResourceAsStream(s"$SYSTEM_REPORTS_TEMPLATE_LOCATION/$templateName")
    new BufferedReader(new InputStreamReader(inputStream))
  }
}
