package com.xebialabs.deployit.test.jackrabbit;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.test.jcr.JcrTestHelper;

import javax.jcr.RepositoryException;

public abstract class JcrTestBase {

    protected static JcrTestHelper jcrTestHelper;

    protected static JcrTemplate jcrTemplate;
    protected static PasswordEncrypter passwordEncrypter;


    @org.junit.BeforeClass
    @org.testng.annotations.BeforeClass
    public static void setupJcrRepository() throws Exception, RepositoryException {
        LocalBooter.bootWithoutGlobalContext();
        jcrTestHelper = new JcrTestHelper();
        jcrTestHelper.setupRepository(new InMemoryRepositoryBooter(), new DefaultConfig());
        jcrTemplate = jcrTestHelper.getJcrTemplate();
        passwordEncrypter = PasswordEncrypter.getInstance();
    }

    @org.junit.AfterClass
    @org.testng.annotations.AfterClass
    public static void shutdownJcrRepository() {
        jcrTestHelper.shutdownRepository();
    }
}
