package com.xebialabs.xlplatform.test.jcr;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import org.modeshape.jcr.api.AnonymousCredentials;
import scala.Option;

import javax.jcr.Credentials;

public class TestRepositoryConfig implements XlRepositoryConfig {

    public static final String TEST_REPOSITORY_JSON = "modeshape/in-memory.json";
//    public static final String TEST_REPOSITORY_JSON = "flat-files.json";
//    public static final String TEST_REPOSITORY_JSON = "h2.json";
//    public static final String TEST_REPOSITORY_JSON = "mysql.json";

    private String repositoryJson;

    public TestRepositoryConfig() {
        this(TEST_REPOSITORY_JSON);
    }

    public TestRepositoryConfig(final String repositoryJson) {
        this.repositoryJson = repositoryJson;
    }

    @Override
    public RepositoryConfigurationSource jcrRepositoryConfig() {
        return new RepositoryConfigurationSource(repositoryJson);
    }

    @Override
    public String repositoryName() {
        return "deployit";
    }

    @Override
    public Version repositoryVersion() {
        return Version.valueOf("deployit", Version.VERSION_0);
    }

    @Override
    public Option<String> repositoryId() {
        return Option.apply(null);
    }

    @Override
    public Option<? extends Credentials> credentials() {
        return Option.apply(new AnonymousCredentials());
    }

}
