package com.xebialabs.xlplatform.test.modeshape;

import org.modeshape.jcr.api.AnonymousCredentials;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;

import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.RepoCredentials;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;

public class TestModeshapeRepositoryConfig implements XlRepositoryConfig {

    public static final String TEST_REPOSITORY_JSON = "modeshape/in-memory.json";
    public static final String CONFIGURATION_LOCATION = "configurationLocation";

    private String repositoryJson;

    public TestModeshapeRepositoryConfig() {
        this(TEST_REPOSITORY_JSON);
    }

    public TestModeshapeRepositoryConfig(final String repositoryJson) {
        this.repositoryJson = repositoryJson;
    }


    @Override
    public Config repositoryConfig() {
        Config modeshapeConfig = ConfigFactory.empty();
        return modeshapeConfig.withValue(CONFIGURATION_LOCATION,
                ConfigValueFactory.fromAnyRef(repositoryJson, "Real modeshape configuration defined in the given file"));
    }

    @Override
    public String repositoryName() {
        return "deployit";
    }

    @Override
    public Version repositoryVersion() {
        return Version.valueOf("deployit", Version.VERSION_0);
    }

    @Override
    public String repositoryId() {
        return null;
    }

    @Override
    public RepoCredentials credentials() {
        return JcrCredentials.apply(new AnonymousCredentials());
    }
}
