package com.xebialabs.xlplatform.test.sql

import com.xebialabs.deployit.booter.local.LocalBooter
import com.zaxxer.hikari.{HikariConfig, HikariDataSource}
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach, Suite}

trait SqlSupport extends BeforeAndAfterAll with BeforeAndAfterEach {
  self: Suite =>
  lazy val dataSource: HikariDataSource = initDataSource()

  override protected def beforeAll(): Unit = {
    super.beforeAll()
    initBooter()
  }

  private def initDataSource(): HikariDataSource = {
    val cfg = new HikariConfig()
    cfg.setInitializationFailFast(true)
    cfg.setDriverClassName("org.h2.Driver")
    cfg.setJdbcUrl("jdbc:h2:mem:db")
    cfg.setUsername("sa")
    cfg.setPassword("")
    cfg.setMaximumPoolSize(20)
    new HikariDataSource(cfg)
  }

  private def initBooter(): Unit = LocalBooter.bootWithoutGlobalContext()

  override protected def afterAll(): Unit = {
    if (dataSource != null) {
      dataSource.close()
    }
    super.afterAll()
  }
}