package com.xebialabs.xlplatform.test.jackrabbit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import com.typesafe.config.Config;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlJcrRepositoryInitializer;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.test.jcr.RepositoryProvider;

public class TestJackrabbitRepositoryBooter implements RepositoryProvider {

    private static final Logger logger = LoggerFactory.getLogger(TestJackrabbitRepositoryBooter.class);

    private RepositoryImpl repository;

    private File homeDir = null;

    public Repository boot(XlRepositoryConfig xlRepositoryConfig) throws RepositoryException {
        try {
            homeDir = Files.createTempDirectory("jackrabbit").toFile();
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        LocalBooter.bootWithoutGlobalContext();
        logger.info("Booting test jackrabbit repository with config {}", xlRepositoryConfig.repositoryName());
        Config jackrabbitRepositoryConfig = xlRepositoryConfig.repositoryConfig();
        RepositoryConfigurationSource configSource = new RepositoryConfigurationSource(jackrabbitRepositoryConfig.getString("configurationLocation"));
        try (InputStream stream = configSource.getInputStream()) {
            InputSource configurationInputSource = new InputSource(stream);
            RepositoryConfig repositoryConfig = RepositoryConfig.create(configurationInputSource, homeDir.getAbsolutePath());
            repository = RepositoryImpl.create(repositoryConfig);
            new XlJcrRepositoryInitializer(xlRepositoryConfig).init(repository);
            return repository;
        } catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void shutdown() {
        logger.info("Shutting down jackrabbit repository");
        repository.shutdown();
        repository = null;
        try {
            GuavaFiles.deleteRecursively(homeDir);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryImpl getRepository() {
        return repository;
    }
}
