package com.xebialabs.xlplatform.test.jcr;

import javax.jcr.*;

public class JcrTools {

    public int removeAllChildren( Session session,
                                  String absPath ) throws RepositoryException {
        try {
            Node node = session.getNode(absPath);
            return removeAllChildren(node);
        } catch (PathNotFoundException e) {
            // ignore
        }
        return 0;
    }

    /**
     * Remove all children from the specified node
     *
     * @param node
     * @return the number of children removed.
     * @throws RepositoryException
     * @throws IllegalArgumentException if the node argument is null
     */
    public int removeAllChildren( Node node ) throws RepositoryException {
        isNotNull(node, "node");
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    private static void isNotNull( Object argument,
                                   String name ) {
        if (argument == null) {
            throw new IllegalArgumentException("The argument \"" + name + "\" may not be null");
        }
    }
}
