/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.test.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JcrTools {
    public int removeAllChildren(Session session, String absPath) throws RepositoryException {
        try {
            Node node = session.getNode(absPath);
            return this.removeAllChildren(node);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return 0;
        }
    }

    public int removeAllChildren(Node node) throws RepositoryException {
        JcrTools.isNotNull(node, "node");
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    private static void isNotNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("The argument \"" + name + "\" may not be null");
        }
    }
}

