package com.xebialabs.xlplatform.ui

import spray.json._

trait MenuJsonProtocol extends DefaultJsonProtocol {
  implicit val iMenuFormat: JsonFormat[IMenu] = lazyFormat(new RootJsonFormat[IMenu] {
    override def write(obj: IMenu): JsValue = obj match {
      case menu: Menu => menu.toJson
      case menuItem: MenuItem => menuItem.toJson
      case menuSeparator: MenuSeparator => menuSeparator.toJson
    }

    override def read(json: JsValue): IMenu = json match {
      case menu: JsObject if menu.fields.isDefinedAt("id") => menu.convertTo[Menu]
      case menuItem: JsObject if menuItem.fields.isDefinedAt("label") => menuItem.convertTo[MenuItem]
      case menuSeparator: JsObject => menuSeparator.convertTo[MenuSeparator]
    }
  })
  implicit val menuItemFormat: RootJsonFormat[MenuItem] = jsonFormat3(MenuItem)
  implicit val menuSeparatorFormat: RootJsonFormat[MenuSeparator] = jsonFormat1(MenuSeparator)
  implicit val menuFormat: JsonFormat[Menu] = lazyFormat(jsonFormat5(Menu))

  implicit val menuListFormat = lazyFormat(new RootJsonFormat[Vector[Menu]] {
    override def read(json: JsValue): Vector[Menu] = json match {
      case JsArray(elems) => elems.map(_.convertTo[Menu])
      case _ => throw new Exception(s"JSON value of type ${json.getClass.getName} cannot be turned into a List[Menu]")
    }

    override def write(obj: Vector[Menu]): JsValue = JsArray(obj.map(_.toJson))
  })

}
