package com.xebialabs.xlplatform.ui

import java.net.URL

class DuplicationException(val ids: Seq[(String, Seq[URL])]) extends RuntimeException() {

  override def getMessage = s"The UI extensions define menus with duplicate IDs: $collisionsHint. Please ensure that each menu has a unique ID, then restart the server."


  def collisionsHint: String = ids collect {
    case (id: String, files: Seq[URL]) => s"$id at ${files.map(_.getPath).mkString(" and ")}"
  } mkString ", "

}
