package com.xebialabs.xlplatform.utils

import grizzled.slf4j.Logging

import scala.concurrent.duration.Duration

trait PerformanceLogging extends Logging {

  def logWithTime[T](msg: => String)( function: => T) : T = {
    val startedAt = System.nanoTime()
    val result = function
    val endedAt = System.nanoTime()
    trace(s"$msg took ${Duration.fromNanos(endedAt - startedAt).toMillis} millis" )
    result
  }
}
