package com.xebialabs.xlplatform.akka25

import akka.actor.ActorSystem

import scala.concurrent.duration.Duration
import scala.concurrent.{Await, TimeoutException}
import scala.util.Try

object Akka25 {
  def terminate(actorSystem: ActorSystem, timeout: Duration = Duration.Inf): Unit = {
    actorSystem.terminate()
    Try {
      Await.ready(actorSystem.whenTerminated, timeout)
    }.recover {
      case (_: InterruptedException) => Thread.currentThread().interrupt()
      case (_: TimeoutException) => // NO-OP
    }
  }
}
