package com.xebialabs.xlplatform.settings

import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory.parseResources
import org.apache.pekko.actor._
import org.apache.pekko.util.Timeout

import java.util.concurrent.TimeUnit
import scala.concurrent.duration._


class XlPlatformSettings(config: Config) extends Extension {
  object FileWatch {
    lazy val interval = config.getDuration("xl.file-watch.interval", TimeUnit.MILLISECONDS).millis
    lazy val pollingEnabled = config.hasPath("xl.file-watch.interval") && interval.toMillis > 0
  }

  object ServerExtension {
    private[this] val serverConfig = config.getConfig("xl.server-extension")
    val file = serverConfig.getString("file")
    val timeout = Timeout(serverConfig.getDuration("timeout", TimeUnit.SECONDS), TimeUnit.SECONDS)
    val rootPath = serverConfig.getString("rootPath")
    val scriptsPathPrefix = serverConfig.getString("scriptsPathPrefix")
  }
}

object XlPlatformSettings extends ExtensionId[XlPlatformSettings] with ExtensionIdProvider {
  override def lookup() = XlPlatformSettings

  override def createExtension(system: ExtendedActorSystem) = apply(system.settings.config)

  def apply(implicit context: ActorContext): XlPlatformSettings = apply(context.system)

  def apply(defaultConfig: Config) = new XlPlatformSettings(
    parseResources("xl-platform.conf").withFallback(defaultConfig))

}
