package com.xebialabs.xlplatform.settings

import java.net.InetAddress

import com.typesafe.config.Config
import com.typesafe.config.ConfigFactory._

import scala.util.Try
import scala.jdk.CollectionConverters._

trait ConfigSupport {

  def loadWithFallbacks(baseConfig: Config, fallbacks: Config*): Config = load(fallbacks.foldLeft(baseConfig)((base, fallback) => base.withFallback(fallback)))

  def hostAddressConfiguration(hostAddressPath: String): Config = {
    val hostname: String = Try(InetAddress.getLocalHost.getHostAddress).getOrElse(InetAddress.getLoopbackAddress.getHostAddress)
    parseMap(Map(hostAddressPath -> hostname).asJava)
  }
}
