package com.xebialabs.xlplatform.pekko

import org.apache.pekko.actor.ActorSystem

import scala.concurrent.duration.Duration
import scala.concurrent.{Await, TimeoutException}
import scala.util.Try

object Pekko {
  def terminate(actorSystem: ActorSystem, timeout: Duration = Duration.Inf): Unit = {
    actorSystem.terminate()
    Try {
      Await.ready(actorSystem.whenTerminated, timeout)
    }.recover {
      case (_: InterruptedException) => Thread.currentThread().interrupt()
      case (_: TimeoutException) => // NO-OP
    }
  }
}
