package com.xebialabs.xlplatform.settings

import java.util
import java.util.concurrent.TimeUnit

import com.typesafe.config.Config

import scala.concurrent.duration.FiniteDuration

trait SettingsSupport {
  import SettingsSupport._
  val config: Config

  def value[T](path: String)(implicit extractor: ValueExtractor[T]): T = extractor(config).apply(path)

  def valueOption[T](path: String)(implicit extractor: ValueExtractor[T]): Option[T] = if (config.hasPath(path)) Option(value(path)(extractor)) else None

  def valueWithDefault[T](path: String, default: T)(implicit extractor: ValueExtractor[T]): T = valueOption(path)(extractor).getOrElse(default)
}
object SettingsSupport {
  type ValueExtractor[T] = (Config) => (String) => T
  implicit val stringExtractor: ValueExtractor[String] = c => c.getString
  implicit val intExtractor: ValueExtractor[Int] = c => c.getInt
  implicit val jListExtractor: ValueExtractor[util.List[String]] = c => c.getStringList
  implicit val booleanExtractor: ValueExtractor[Boolean] = c => c.getBoolean
  implicit val configExtractor: ValueExtractor[Config] = c => c.getConfig
  implicit val durationExtractor: ValueExtractor[FiniteDuration] = c => (path: String) => FiniteDuration(c.getDuration(path, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)
  implicit val $conforms: ValueExtractor[SettingsSupport] = null // to shade Predef.conforms implicit

  implicit class RichConfig(val config: Config) extends AnyVal {
    def value[T](path: String)(implicit extractor: ValueExtractor[T]): T = extractor(config).apply(path)

    def valueOption[T](path: String)(implicit extractor: ValueExtractor[T]): Option[T] = if (config.hasPath(path)) Option(value(path)(extractor)) else None

    def valueWithDefault[T](path: String, default: T)(implicit extractor: ValueExtractor[T]): T = valueOption(path)(extractor).getOrElse(default)
  }

}