package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}
import grizzled.slf4j.Logging


trait EventSourceHandler[E <: Event, S <: EventSource] {
  self: Logging =>

  def publishEvent(config: S, event: E): Boolean

  def publish(config: S, event: E): Boolean = {
    logger.trace(s"publish($config, $event)")
    if (config.sourceEnabled) {
      if (config.outputType == null || event.getType.instanceOf(config.outputType)) {
        logger.trace("types match, publishing!")
        publishEvent(config, event)
      } else {
        logger.warn(s"types mismatch on source ${config.sourceId} expected: ${config.outputType}, got ${event.getType}")
        false
      }
    } else {
      logger.trace(s"source ${config.sourceId} disabled, not publishing ${event.getId}")
      false
    }
  }
}
