package com.xebialabs.xlplatform.webhooks.authentication

import com.xebialabs.xlplatform.webhooks.domain.Endpoint

import scala.collection.JavaConverters._

// Implement at least one of the methods
trait RequestAuthenticationMethod {
  def authenticateScala(endpoint: Endpoint,
                        headers: Map[String, String],
                        params: Map[String, Array[String]],
                        payload: String): Boolean =
    authenticate(endpoint, headers.asJava, params.asJava, payload)

  def authenticate(endpoint: Endpoint,
                   headers: java.util.Map[String, String],
                   params: java.util.Map[String, Array[String]],
                   payload: String): Boolean =
    authenticateScala(endpoint, headers.asScala.toMap, params.asScala.toMap, payload)

}
