/**
 * This service wraps $http in order to work with XML REST services provided by XL Deploy.
 * Once XL Deploy exposes JSON interface, this service should be gone.
 */
angular.module('CompareApp').factory('xmlHttp', function ($http, $q) {

        var XML_REST_CONFIG = {
            headers: {
                "Content-Type": "application/xml",
                "Accept": "application/xml"
            },

            transformResponse: function(data) {
                //our backend returns invalid xml when errors occur and cannot be correctly parsed as xml.
                try {
                    var td = (new X2JS({escapeMode: false})).xml_str2json(data);
                    if ((_.isUndefined(td) || _.isEmpty(td)) && data) {   //chrome, safari, phantomJS returns null for invalid xml.
                        return data;
                    } else {
                        if (td.parsererror ||                                           /* ff return an object with a parsererror attribute*/
                            td.html && td.html.body && td.html.body.parsererror) {      /* phantomJS parsererror attribute */
                            return data;
                        }
                        return td;
                    }
                } catch (err) {   //IE throws parse exception.
                    return data;
                }
            },

            transformRequest: function(data) {
                return (new X2JS({escapeMode:false})).json2xml_str( data );
            }
        };

        var successWrapper = function(result) {
            return result.data;
        };

        var errorWrapper = function(error) {
            return $q.reject(error.data || error.message);
        };

        var withExtraConfig = function(config) {
            return config ? angular.extend(angular.copy(XML_REST_CONFIG), config) : XML_REST_CONFIG;
        };

        return {
            'get': function(url, config) {
                return $http.get(url, withExtraConfig(config)).then(successWrapper, errorWrapper);
            },
            'post': function(url, data, config) {
                return $http.post(url, data || {}, withExtraConfig(config)).then(successWrapper, errorWrapper);
            }
        }
    });