/*
 * This file is part of Maven Deployit plugin.
 *
 * Maven Deployit plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Maven Deployit plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maven Deployit plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.xebialabs.deployit.maven;


import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static java.lang.String.format;


/**
 * Import a Deployment Package into a Deployit server.
 *
 * @author Benoit Moussaud
 * @goal import
 * @requiresProject
 * @phase pre-integration-test
 * @requiresDependencyResolution compile
 * @configurator override
 */

public class ImportDarMojo extends AbstractDeployitMojo {

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("xldeploy:import");
        boot();
        try {
            final ConfigurationItem version = getDeploymentHelper().uploadPackage(getPackager().perform());
            getLog().info(format("Application ['%s'] has been imported", version.getId()));
        } finally {
            shutdown();
        }
        getLog().info("end of xldeploy:import");
    }

}
