/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.components;

import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.messages.CrawlerDataMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.crawlers.shared.components.CrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;

public abstract class BaseCrawlResolver<C extends AbstractCrawler, T extends CrawlerMessage<T>>
implements CrawlResolver<C, T> {
    protected final CrawlFactory<C> crawlFactory;

    public BaseCrawlResolver(CrawlFactory<C> crawlFactory) {
        this.crawlFactory = crawlFactory;
    }

    @Override
    public CrawlService resolve(C crawler, CrawlerJobWrapper<T> crawlerJob) throws CrawlerWorkException {
        try {
            if (crawlerJob.getMessage() instanceof CrawlerDataMessage) {
                return this.handleAllCrawlMessage(crawler, crawlerJob);
            }
            return this.handleLaunchCrawlMessage(crawler, crawlerJob);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    protected abstract CrawlService handleLaunchCrawlMessage(C var1, CrawlerJobWrapper<T> var2) throws IllegalAccessException, InstantiationException;

    protected CrawlService handleAllCrawlMessage(C crawler, CrawlerJobWrapper<T> crawlerJob) throws CrawlerWorkException {
        return this.crawlFactory.getInstance(crawler, (CrawlerDataMessage)crawlerJob.getMessage());
    }
}

