/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.google.common.collect.Maps;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Branch;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.BranchResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketBranchCrawl
extends BitbucketBaseCrawl<BitbucketBranchJobMessage, BranchResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketBranchCrawl.class);

    public BitbucketBranchCrawl(BitbucketCrawler crawler, BitbucketBranchJobMessage message, BaseCrawlerMessage crawlerDataMessage) {
        super(crawler, message, crawlerDataMessage);
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketBranchJobMessage.class, this.message).setUrl(this.nextURL);
            return this.createDataMessage(BitbucketBranchJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<BranchResponse> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketBranchJobMessage for Team - {}, Rep - {}", (Object)((BitbucketBranchJobMessage)this.message).getTeamName(), (Object)((BitbucketBranchJobMessage)this.message).getRepoName());
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.responseFetcher.fetch(BranchResponse.class, ((BitbucketBranchJobMessage)this.message).crawlUrl());
        this.handleResponse((BranchResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(BranchResponse response) throws CrawlerWorkException {
        logger.debug("Found {} branches in repo {}", (Object)response.getValues().size(), (Object)((BitbucketBranchJobMessage)this.message).getRepoName());
        List results = response.getValues();
        for (Branch branch : results) {
            this.crawlCommitMessage((BitbucketRepoJobMessage)this.message, branch.linkFor("commits"), Maps.immutableEntry((Object)branch.getTarget().getHash(), (Object)branch.getTarget().fetchUrl()));
        }
    }
}

