/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.UrlParts;

public class UrlPartsAggregator
implements Aggregator<PullRequestUM, PullRequest> {
    private String project;
    private String repo;

    public UrlPartsAggregator(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    @Override
    public void populate(PullRequestUM pullRequestUM, PullRequest pullRequest) {
        UrlParts urlParts = new UrlParts();
        urlParts.setRepository(this.repository());
        urlParts.setId(Integer.toString(pullRequest.getId()));
        urlParts.setRepo(this.repo);
        urlParts.setProject(this.project);
        pullRequestUM.setUrlParts(urlParts);
    }

    private String repository() {
        return BitbucketUtil.generateDataId(this.project, this.repo);
    }
}

